/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.data.KeyedValues3D;
import com.orsoncharts.data.KeyedValues3DItemKey;
import com.orsoncharts.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;

public class KeyedValues3DItemKeys {
    private KeyedValues3DItemKeys() {
    }

    public static Collection<KeyedValues3DItemKey> itemKeysForSeries(KeyedValues3D data, Comparable<?> seriesKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        ArrayList<KeyedValues3DItemKey> result = new ArrayList<KeyedValues3DItemKey>();
        if (!data.getSeriesKeys().contains(seriesKey)) {
            return result;
        }
        for (Comparable<?> rowKey : data.getRowKeys()) {
            for (Comparable<?> columnKey : data.getColumnKeys()) {
                KeyedValues3DItemKey key = new KeyedValues3DItemKey(seriesKey, rowKey, columnKey);
                result.add(key);
            }
        }
        return result;
    }

    public static Collection<KeyedValues3DItemKey> itemKeysForRow(KeyedValues3D data, Comparable<?> rowKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(rowKey, "rowKey");
        ArrayList<KeyedValues3DItemKey> result = new ArrayList<KeyedValues3DItemKey>();
        if (!data.getRowKeys().contains(rowKey)) {
            return result;
        }
        for (Comparable<?> seriesKey : data.getSeriesKeys()) {
            for (Comparable<?> columnKey : data.getColumnKeys()) {
                KeyedValues3DItemKey key = new KeyedValues3DItemKey(seriesKey, rowKey, columnKey);
                result.add(key);
            }
        }
        return result;
    }

    public static Collection<KeyedValues3DItemKey> itemKeysForColumn(KeyedValues3D data, Comparable<?> columnKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(columnKey, "columnKey");
        ArrayList<KeyedValues3DItemKey> result = new ArrayList<KeyedValues3DItemKey>();
        if (!data.getColumnKeys().contains(columnKey)) {
            return result;
        }
        for (Comparable<?> seriesKey : data.getSeriesKeys()) {
            for (Comparable<?> rowKey : data.getRowKeys()) {
                KeyedValues3DItemKey key = new KeyedValues3DItemKey(seriesKey, rowKey, columnKey);
                result.add(key);
            }
        }
        return result;
    }
}

