/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf.util;

import com.orsonpdf.util.Args;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class GraphicsUtils {
    private GraphicsUtils() {
    }

    public static Shape copyOf(Shape shape) {
        Args.nullNotPermitted(shape, "shape");
        if (shape instanceof Line2D) {
            Line2D l = (Line2D)shape;
            return new Line2D.Double(l.getX1(), l.getY1(), l.getX2(), l.getY2());
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)shape;
            return new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }
        if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)shape;
            return new RoundRectangle2D.Double(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
        }
        if (shape instanceof Arc2D) {
            Arc2D arc = (Arc2D)shape;
            return new Arc2D.Double(arc.getX(), arc.getY(), arc.getWidth(), arc.getHeight(), arc.getAngleStart(), arc.getAngleExtent(), arc.getArcType());
        }
        if (shape instanceof Ellipse2D) {
            Ellipse2D ell = (Ellipse2D)shape;
            return new Ellipse2D.Double(ell.getX(), ell.getY(), ell.getWidth(), ell.getHeight());
        }
        if (shape instanceof Polygon) {
            Polygon p = (Polygon)shape;
            return new Polygon(p.xpoints, p.ypoints, p.npoints);
        }
        return new Path2D.Double(shape);
    }

    public static GeneralPath createPolygon(int[] xPoints, int[] yPoints, int nPoints, boolean close) {
        GeneralPath p = new GeneralPath();
        p.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            p.lineTo(xPoints[i], yPoints[i]);
        }
        if (close) {
            p.closePath();
        }
        return p;
    }

    public static BufferedImage convertRenderedImage(RenderedImage img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        ColorModel cm = img.getColorModel();
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = img.getPropertyNames();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                properties.put(keys[i], img.getProperty(keys[i]));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        return result;
    }
}

