/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt.editor;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

class SWTStrokeCanvas
extends Canvas {
    public SWTStrokeCanvas(Composite parent, int style, Image image) {
        this(parent, style);
    }

    public SWTStrokeCanvas(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                BasicStroke stroke = SWTStrokeCanvas.this.getStroke();
                if (stroke != null) {
                    Rectangle rect = SWTStrokeCanvas.this.getClientArea();
                    int x = (rect.width - 100) / 2;
                    int y = (rect.height - 16) / 2;
                    Transform swtTransform = new Transform(e.gc.getDevice());
                    e.gc.getTransform(swtTransform);
                    swtTransform.translate((float)x, (float)y);
                    e.gc.setTransform(swtTransform);
                    swtTransform.dispose();
                    e.gc.setBackground(SWTStrokeCanvas.this.getDisplay().getSystemColor(2));
                    e.gc.setLineWidth((int)stroke.getLineWidth());
                    e.gc.drawLine(10, 8, 90, 8);
                }
            }
        });
    }

    public void setStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            throw new RuntimeException("Can only handle 'Basic Stroke' at present.");
        }
        this.setData(stroke);
    }

    public BasicStroke getStroke() {
        return (BasicStroke)this.getData();
    }
}

