/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;

public class Benchmark {
    static final int N = 10000;
    static CLibDM m_CLibDM;
    static CLib m_CLibIB;
    static CLib m_CLib;
    static long m_BytesN;
    static byte[] m_Bytes;
    static Memory m_Memory;
    public static volatile int m_Dummy;

    static {
        m_BytesN = 512L;
        m_Bytes = new byte[(int)m_BytesN];
        m_Memory = new Memory(m_BytesN);
    }

    static void call_memset() {
        m_CLib.memset(m_Bytes, 69, m_BytesN);
    }

    static void call_memset2() {
        m_CLib.memset(m_Memory, 69, m_BytesN);
    }

    static void call_memmove() {
        m_CLib.memmove(m_Bytes, m_Bytes, m_BytesN);
    }

    static void call_memmove2() {
        m_CLib.memmove(m_Memory, m_Memory, m_BytesN);
    }

    static int call_htonl() {
        return m_CLib.htonl(-559038737);
    }

    static int call_nothing() {
        return m_Dummy;
    }

    public static void runBenchmarks(double[] res, int offs) {
        long t0 = System.nanoTime();
        int i = 0;
        while (i < 10000) {
            Benchmark.call_nothing();
            ++i;
        }
        long bl = System.nanoTime() - t0;
        t0 = System.nanoTime();
        int i2 = 0;
        while (i2 < 10000) {
            Benchmark.call_htonl();
            ++i2;
        }
        res[offs++] = (System.nanoTime() - t0 - bl) / 10000L;
        t0 = System.nanoTime();
        i2 = 0;
        while (i2 < 10000) {
            Benchmark.call_memset();
            ++i2;
        }
        long dt = System.nanoTime() - t0;
        res[offs++] = (System.nanoTime() - t0 - bl) / 10000L;
        t0 = System.nanoTime();
        i2 = 0;
        while (i2 < 10000) {
            Benchmark.call_memset2();
            ++i2;
        }
        dt = System.nanoTime() - t0;
        res[offs++] = (System.nanoTime() - t0 - bl) / 10000L;
        t0 = System.nanoTime();
        i2 = 0;
        while (i2 < 10000) {
            Benchmark.call_memmove();
            ++i2;
        }
        dt = System.nanoTime() - t0;
        res[offs++] = (System.nanoTime() - t0 - bl) / 10000L;
        t0 = System.nanoTime();
        i2 = 0;
        while (i2 < 10000) {
            Benchmark.call_memmove2();
            ++i2;
        }
        dt = System.nanoTime() - t0;
        res[offs++] = (System.nanoTime() - t0 - bl) / 10000L;
    }

    public static void main(String[] args) {
        try {
            Native.register(CLibDM.class, NativeLibrary.getInstance("c"));
            m_CLibDM = new CLibDM();
            m_CLibIB = Native.loadLibrary("c", CLib.class);
            double[] res = new double[10];
            int i = 0;
            while (i < 10000) {
                m_CLib = m_CLibIB;
                Benchmark.runBenchmarks(res, 0);
                m_CLib = m_CLibDM;
                Benchmark.runBenchmarks(res, 5);
                int j = 0;
                while (j < res.length) {
                    System.out.printf("%15.3f", res[j] / 1000.0);
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.printf("%15s%15s%150s%15s%15s%15s\n", "IB/htonl", "IB/memset", "IB/memmove", "DM/htonl", "DM/htonl", "DM/memmove");
            System.out.printf("results in usec", new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static interface CLib
    extends Library {
        public int htonl(int var1);

        public void memset(byte[] var1, int var2, long var3);

        public void memset(Pointer var1, int var2, long var3);

        public void memmove(byte[] var1, byte[] var2, long var3);

        public void memmove(Pointer var1, Pointer var2, long var3);
    }

    public static class CLibDM
    implements CLib {
        public native int htonl(int var1);

        public native void memset(byte[] var1, int var2, long var3);

        public native void memset(Pointer var1, int var2, long var3);

        public native void memmove(byte[] var1, byte[] var2, long var3);

        public native void memmove(Pointer var1, Pointer var2, long var3);
    }
}

